DELIMITER $$
DROP PROCEDURE IF EXISTS V20210317193840__Update_dydtAcademyLocationAddress $$
CREATE PROCEDURE V20210317193840__Update_dydtAcademyLocationAddress()
BEGIN

SET SQL_SAFE_UPDATES = 0;

IF EXISTS ((select * from `dydt_data_line_item` where `dataSourceCode` = 'ACADEMYLOCATION_ADDRESS')) THEN

SET @dydtDataLineItemId = (select id from `dydt_data_line_item` where `dataSourceCode` = 'ACADEMYLOCATION_ADDRESS');

UPDATE `dydt_data_line_item` 
SET `sqlSelectQueryDef`=
'SELECT 
 al.academyId AS academy_id , al.locationId AS location_id , al.academyName AS academy_name , al.locationName AS location_name,
 c.countryName AS country_name , cr.countryRegionName AS region_name ,
 pr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,
 ad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,
 ad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no,
 ad.primaryeEmailId as primary_email_id, al.path as img_academy_location,
al.displayName as academy_location_display_name,
addressText AS academy_loc_address_detail,
ad.phoneAreaCode AS academy_loc_phone_area_code,
ad.primaryeEmailId as academy_loc_primary_email_id,
al.displayNameOL as academy_location_display_name_ol,
ad.phoneCountryCode AS al_phone_country_code,
ad.phoneNo AS al_phone_no
 FROM academy_location al
 LEFT JOIN location_addresses la ON al.locationId = la.locationId
 LEFT JOIN address ad ON la.addressId = ad.id AND ad.addressTypeId = 3
 LEFT JOIN city ct ON ct.id =ad.cityId
 LEFT JOIN country c ON ad.countryId = c.id
 LEFT JOIN country_region cr ON ad.countryRegionId = cr.id
 LEFT JOIN country_region pr ON ad.parentRegionId = pr.id', 
`resultColumnsDef`='academy_id,location_id,academy_name,location_name,country_name,region_name,parent_region_name,city_name,address_detail,phone_country_code,phone_area_code,phone_no,cell_country_code,cell_no,primary_email_id,img_academy_location,academy_location_display_name,academy_loc_address_detail,academy_loc_phone_area_code,academy_loc_primary_email_id,academy_location_display_name_ol,al_phone_country_code,al_phone_no' 
WHERE `id` = @dydtDataLineItemId;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'al_phone_country_code')) THEN

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('al_phone_country_code', 'Academy Location Phone Country Code', @dydtDataLineItemId);

END IF;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'al_phone_no')) THEN

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('al_phone_no', 'Academy Location Phone Number', @dydtDataLineItemId);

END IF;

END IF;

SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20210317193840__Update_dydtAcademyLocationAddress() $$
DROP PROCEDURE IF EXISTS V20210317193840__Update_dydtAcademyLocationAddress $$
DELIMITER ;